/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.visuals;

import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.game.WorldChangeEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.Render3DEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.game.WorldUtility;
import Krasnodar.rockstarnew.utility.render.Draw3DUtility;
import Krasnodar.rockstarnew.utility.render.RenderUtility;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2601;
import net.minecraft.class_2608;
import net.minecraft.class_2611;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2646;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3719;
import net.minecraft.class_3866;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

@ModuleInfo(name="Storage ESP", category=ModuleCategory.VISUALS)
public class StorageESP
extends BaseModule {
    private static final class_238 FULL_BOX = new class_238(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final class_238 EMPTY_BOX = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final SelectSetting blocks = new SelectSetting(this, "modules.settings.storage_esp.blocks");
    private final SelectSetting.Value chests = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.chests").select();
    private final SelectSetting.Value enderChests = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.ender_chests").select();
    private final SelectSetting.Value trappedChests = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.trapped_chests");
    private final SelectSetting.Value furnaces = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.furnaces");
    private final SelectSetting.Value barrels = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.barrels").select();
    private final SelectSetting.Value minecart = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.minecart").select();
    private final SelectSetting.Value shulkers = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.shulkers").select();
    private final SelectSetting.Value droppers = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.droppers");
    private final SelectSetting.Value dispensers = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.dispensers");
    private final SelectSetting.Value hoppers = new SelectSetting.Value(this.blocks, "modules.settings.storage_esp.blocks.hoppers");
    private final SelectSetting renderMode = new SelectSetting(this, "modules.settings.storage_esp.render");
    private final SelectSetting.Value fill = new SelectSetting.Value(this.renderMode, "modules.settings.storage_esp.render.fill").select();
    private final SelectSetting.Value outline = new SelectSetting.Value(this.renderMode, "modules.settings.storage_esp.render.outline").select();
    private final SelectSetting.Value diagonals = new SelectSetting.Value(this.renderMode, "modules.settings.storage_esp.render.diagonals").select();
    private final SelectSetting.Value lines = new SelectSetting.Value(this.renderMode, "modules.settings.storage_esp.render.lines");
    private final SliderSetting maxDistance = new SliderSetting((SettingsContainer)this, "modules.settings.storage_esp.max_distance", "modules.settings.storage_esp.max_distance.description").min(5.0f).max(128.0f).step(1.0f).currentValue(128.0f);
    private final EventListener<Render3DEvent> on3DRender = event -> {
        if (StorageESP.mc.field_1687 != null && StorageESP.mc.field_1724 != null) {
            class_4587 matrices = event.getMatrices();
            class_4184 camera = StorageESP.mc.field_1773.method_19418();
            class_243 cameraPos = camera.method_19326();
            RenderSystem.enableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.disableCull();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
            RenderSystem.setShader((class_10156)class_10142.field_53876);
            class_287 quadsBuffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_27382, class_290.field_1576);
            for (class_2586 blockEntity : WorldUtility.blockEntities) {
                if (!this.isValidEntity(blockEntity)) continue;
                for (class_238 class_2383 : this.getBoundingBox(blockEntity)) {
                    if (!this.fill.isSelected()) continue;
                    Draw3DUtility.renderFilledBox(matrices, quadsBuffer, class_2383.method_989(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215()), this.getBlockColor(blockEntity).withAlpha(50.0f));
                }
            }
            for (class_1297 entity : StorageESP.mc.field_1687.method_18112()) {
                if (!this.isValidCart(entity)) continue;
                class_238 boundingBoxx = entity.method_5829();
                if (!this.fill.isSelected()) continue;
                Draw3DUtility.renderFilledBox(matrices, quadsBuffer, boundingBoxx.method_989(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215()), this.getEntityColor(entity).withAlpha(50.0f));
            }
            RenderUtility.buildBuffer(quadsBuffer);
            class_287 linesBuffer = RenderSystem.renderThreadTesselator().method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            for (class_2586 blockEntityx : WorldUtility.blockEntities) {
                if (!this.isValidEntity(blockEntityx)) continue;
                for (class_238 boundingBoxx : this.getBoundingBox(blockEntityx)) {
                    if (this.diagonals.isSelected()) {
                        Draw3DUtility.renderBoxInternalDiagonals(matrices, linesBuffer, boundingBoxx.method_989(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215()), this.getBlockColor(blockEntityx).withAlpha(100.0f));
                    }
                    if (this.outline.isSelected()) {
                        Draw3DUtility.renderOutlinedBox(matrices, linesBuffer, boundingBoxx.method_989(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215()), this.getBlockColor(blockEntityx).withAlpha(100.0f));
                    }
                    if (!this.lines.isSelected()) continue;
                    class_243 entityPos = blockEntityx.method_11016().method_46558();
                    Draw3DUtility.renderLineFromPlayer(matrices, linesBuffer, entityPos, this.getBlockColor(blockEntityx));
                }
            }
            for (class_1297 entityx : StorageESP.mc.field_1687.method_18112()) {
                if (!this.isValidCart(entityx)) continue;
                class_238 class_2384 = entityx.method_5829();
                if (this.diagonals.isSelected()) {
                    Draw3DUtility.renderBoxInternalDiagonals(matrices, linesBuffer, class_2384.method_989(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215()), this.getEntityColor(entityx).withAlpha(100.0f));
                }
                if (this.outline.isSelected()) {
                    Draw3DUtility.renderOutlinedBox(matrices, linesBuffer, class_2384.method_989(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215()), this.getEntityColor(entityx).withAlpha(100.0f));
                }
                if (!this.lines.isSelected()) continue;
                class_243 entityPos = entityx.method_19538();
                Draw3DUtility.renderLineFromPlayer(matrices, linesBuffer, entityPos, this.getEntityColor(entityx));
            }
            RenderUtility.buildBuffer(linesBuffer);
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.disableBlend();
        }
    };
    private final EventListener<WorldChangeEvent> onWorldChange = event -> WorldUtility.blockEntities.clear();

    private List<class_238> getBoundingBox(class_2586 blockEntity) {
        if (StorageESP.mc.field_1687 == null) {
            return List.of(EMPTY_BOX);
        }
        class_2338 blockPos = blockEntity.method_11016();
        class_2680 blockState = StorageESP.mc.field_1687.method_8320(blockPos);
        class_265 shape = blockState.method_26218((class_1922)StorageESP.mc.field_1687, blockPos);
        return shape.method_1110() ? List.of(FULL_BOX.method_996(blockPos)) : shape.method_1090().stream().map(box -> box.method_996(blockPos)).toList();
    }

    private boolean isValidEntity(class_2586 entity) {
        double maxDistSq = this.maxDistance.getCurrentValue() * this.maxDistance.getCurrentValue();
        if (StorageESP.mc.field_1724 == null || StorageESP.mc.field_1724.method_5707(entity.method_11016().method_46558()) > maxDistSq) {
            return false;
        }
        if (entity instanceof class_2595 && this.chests.isSelected()) {
            return true;
        }
        if (entity instanceof class_2611 && this.enderChests.isSelected()) {
            return true;
        }
        if (entity instanceof class_2646 && this.trappedChests.isSelected()) {
            return true;
        }
        if (entity instanceof class_3866 && this.furnaces.isSelected()) {
            return true;
        }
        if (entity instanceof class_3719 && this.barrels.isSelected()) {
            return true;
        }
        if (entity instanceof class_2627 && this.shulkers.isSelected()) {
            return true;
        }
        if (entity instanceof class_2608 && this.droppers.isSelected()) {
            return true;
        }
        return entity instanceof class_2601 && this.dispensers.isSelected() ? true : entity instanceof class_2614 && this.hoppers.isSelected();
    }

    private ColorRGBA getBlockColor(class_2586 entity) {
        if (entity instanceof class_2595) {
            return new ColorRGBA(255.0f, 131.0f, 54.0f);
        }
        if (entity instanceof class_2611) {
            return new ColorRGBA(121.0f, 54.0f, 255.0f);
        }
        if (entity instanceof class_2646) {
            return new ColorRGBA(255.0f, 101.0f, 54.0f);
        }
        if (entity instanceof class_3866) {
            return new ColorRGBA(126.0f, 126.0f, 126.0f);
        }
        if (entity instanceof class_3719) {
            return new ColorRGBA(255.0f, 185.0f, 54.0f);
        }
        if (entity instanceof class_2627) {
            return new ColorRGBA(181.0f, 54.0f, 255.0f);
        }
        if (entity instanceof class_2608) {
            return new ColorRGBA(100.0f, 100.0f, 100.0f);
        }
        if (entity instanceof class_2601) {
            return new ColorRGBA(100.0f, 100.0f, 100.0f);
        }
        return entity instanceof class_2614 ? new ColorRGBA(100.0f, 100.0f, 100.0f) : Colors.WHITE;
    }

    private ColorRGBA getEntityColor(class_1297 entity) {
        return entity instanceof class_1694 ? new ColorRGBA(255.0f, 200.0f, 100.0f) : Colors.WHITE;
    }

    private boolean isValidCart(class_1297 entity) {
        double maxDistSq = this.maxDistance.getCurrentValue() * this.maxDistance.getCurrentValue();
        return StorageESP.mc.field_1724 != null && !(StorageESP.mc.field_1724.method_5707(entity.method_19538()) > maxDistSq) ? entity instanceof class_1694 && this.minecart.isSelected() : false;
    }
}

